<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'phone', 'package_id', 'price');

    public function features()
    {
        return $this->belongsToMany('Feature');
    }

    public function accounts()
    {
        return $this->hasMany('Account');
    }

    public function tickets()
    {
        return $this->hasMany('Ticket');
    }

    public function package()
    {
        return $this->belongsTo('Packages');
    }

    public function subscriptions()
    {
        return $this->hasMany('Subscription');
    }

}